% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ices_post.R
\name{ices_post}
\alias{ices_post}
\title{Post to a url}
\usage{
ices_post(url, body = list(), retry = TRUE, verbose = FALSE, use_token = TRUE)
}
\arguments{
\item{url}{the url to get.}

\item{body}{a list of named arguments to be sent as the body of the
post request.}

\item{retry}{should the get request be retried if first attempt
fails? default TRUE.}

\item{verbose}{should verbose output form the http request be
returned? default FALSE.}

\item{use_token}{should an authentication token be sent with the
request? default is TRUE.}
}
\value{
content or an http response.
}
\description{
Post to a url using an ICES authentication token
}
\examples{
\dontrun{
ices_get(sag_api("StockList", year = 2022))
}
}
\seealso{
\code{\link{sag_api}} builds a SAG web service url.

\code{\link{icesSAG-package}} gives an overview of the package.
}
