% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div.R
\name{div}
\alias{div}
\title{Divide Columns}
\usage{
div(x, cols, by = 1000)
}
\arguments{
\item{x}{a data frame.}

\item{cols}{column names.}

\item{by}{a number to divide with.}
}
\value{
A data frame similar to \code{x}, after dividing columns \code{cols} by the
number \code{by}.
}
\description{
Divide column values in a data frame with a common number.
}
\note{
Provides notation that is reliable and convenient for modifying a large
number of columns, not repeating column names twice.
}
\examples{
summary <- div(summary.taf,
  c("Rec","Rec_lo","Rec_hi","TSB","TSB_lo","TSB_hi","SSB","SSB_lo","SSB_hi"))

}
\seealso{
\code{\link{sweep}} and \code{\link{transform}} can also be used to
recalculate column values, using a more general and verbose syntax.

\code{\link{rnd}} is a similar function to round columns.

\code{\link{icesTAF-package}} gives an overview of the package.
}
