% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.encoding.R
\name{file.encoding}
\alias{file.encoding}
\title{File Encoding}
\usage{
file.encoding(file)
}
\arguments{
\item{file}{a filename.}
}
\value{
\code{"latin1"}, \code{"UTF-8"}, \code{"unknown"}, or \code{NA}.

This function requires the \command{file} shell command. If the
\command{file} utility is not found in the path, this function looks for it
inside \file{c:/Rtools/bin}. If the required software is not installed, this
function returns \code{NA}.
}
\description{
Examine file encoding.
}
\note{
The encoding \code{"unknown"} indicates that the file is an ASCII text file
or a binary file.

In TAF, text files that have non-ASCII characters must be encoded as UTF-8.
}
\examples{
\dontrun{
file.base <- system.file(package="base", "DESCRIPTION")
file.nlme <- system.file(package="nlme", "DESCRIPTION")
file.encoding(file.base)  # ASCII
file.encoding(file.nlme)
}

}
\seealso{
\code{\link{Encoding}} examines the encoding of a string.

\code{\link{latin1.to.utf8}} converts files from \verb{latin1} to
\verb{UTF-8} encoding.

\code{\link{line.endings}} examines line endings.

\code{\link{icesTAF-package}} gives an overview of the package.
}
