% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findCode.R
\name{findCode}
\alias{findCode}
\title{Find a Key}
\usage{
findCode(code_type, code, regex = TRUE, full = FALSE)
}
\arguments{
\item{code_type}{a search string for a code type, e.g. SpecWorms, or simply worms.}

\item{code}{a search string for a code, e.g. a species name, cod, or ship name, Clupea.}

\item{regex}{whether to match as a regular expression.}

\item{full}{whether to return a data frame.}
}
\value{
A vector of keys (default) or a data frame if full is TRUE.
}
\description{
Look up a key for a given code and code type.
}
\details{
Matches are case-insensitive.
}
\examples{
\donttest{
findCode("aphia", "cod")

# Multiple matches
findCode("aphia", c("cod", "haddock", "saithe"), full = TRUE)

findCodeType("ship", full = TRUE)
findCode("ship", "clupea", full = TRUE)
}

}
\seealso{
\code{\link{getCodeList}} can be used to get all code types; see example on
that help page.

\code{\link{icesVocab-package}} gives an overview of the package.
}
