% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as_tibble}
\alias{as_tibble}
\alias{as_tibble.ichimoku}
\title{Convert ichimoku to tibble}
\usage{
\method{as_tibble}{ichimoku}(x, class, keep.attrs, ...)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{class}{(optional) as a character vector, subclasses to assign to the
new object.}

\item{keep.attrs}{(optional) if set to TRUE, will preserve any custom
attributes set on the original object.}

\item{...}{arguments passed to or from other methods.}
}
\value{
A 'tibble' with S3 classes of 'tbl_df', 'tbl' and 'data.frame'. The
    ichimoku object index is preserved as the first column with header 'index'.
}
\description{
An optimised 'ichimoku' to 'tibble' constructor.
}
\details{
This function is an S3 method for the generic function
    as_tibble() for class 'ichimoku'. It can be invoked by calling
    as_tibble(x) on an object 'x' of class 'ichimoku'.
}
\examples{
cloud <- ichimoku(sample_ohlc_data)
tbl <- as_tibble(cloud)
str(tbl)

tbl2 <- as_tibble(cloud, keep.attrs = TRUE)
str(tbl2)

}
