% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{df_append}
\alias{df_append}
\title{Append New Data to Dataframe}
\usage{
df_append(old, new, key = "time", keep.attr = "timestamp")
}
\arguments{
\item{old}{data.frame object containing existing data.}

\item{new}{data.frame object containing new data.}

\item{key}{[default 'time'] column name used as key, provided as a character
string.}

\item{keep.attr}{[default 'timestamp'] name of an attribute in \sQuote{new}
to retain, if present, provided as a character string.}
}
\value{
A data.frame of the existing data appended with the new data. If the
    data in \sQuote{new} contains data with the same value for the key column
    as \sQuote{old}, the data in \sQuote{new} will overwrite the data in
    \sQuote{old}.

    If the attribute specified by \sQuote{keep.attr} is present in
    \sQuote{new}, this is retained. All other non-required attributes are
    dropped.
}
\description{
Update a 'data.frame' object with new data. Can be used to append new updated
    time series data to an existing dataframe, where each observation is
    indexed by a unique timestamp/identifier in a key column.
}
\details{
Can be used to update price dataframes retrieved by
    \code{\link{oanda}}. The function is designed to update existing data
    with new values as they become available. As opposed to
    \code{\link{df_merge}}, the data in \sQuote{new} will overwrite the data
    in \sQuote{old} rather than create duplicates.
}
\examples{
data1 <- sample_ohlc_data[1:8, ]
data1
data2 <- sample_ohlc_data[7:10, ]
data2
df_append(data1, data2)

}
