% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-graphs.R
\name{vicinity}
\alias{vicinity}
\alias{vicinity,trigrid,character-method}
\title{The neighbouring faces of faces in an icosahedral grid}
\usage{
vicinity(gridObj, faces, ...)

\S4method{vicinity}{trigrid,character}(
  gridObj,
  faces,
  order = 1,
  output = "vector",
  self = TRUE,
  namedorder = FALSE,
  ...
)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}} or \code{\link{hexagrid}}) Icosahedral grid object.}

\item{faces}{(\code{character}) A vector specifying names of faces.}

\item{...}{Arguments passed to the \code{\link[igraph]{ego}} function.}

\item{order}{(\code{numeric}) Passed to the \code{\link[igraph]{ego}} function, an integer value specifying the size of the neighborhood around a face.}

\item{output}{(\code{character}) The type of the output. The default \code{"vector"} 
will give back the names of the faces that adjacent to the faces specified, 
including themselves. \code{"list"} will return a list.}

\item{self}{(\code{logical}) Flag indicating whether the input faces should be in the output. For the \code{"list"} output option, the input face names will be
omitted only from those character vectors that contain face names that are related to the face in question.}

\item{namedorder}{(\code{logical}) Should the orders of the neighbouring cells be reported (\code{TRUE}) or just the names of the cells (default, \code{FALSE}).}
}
\value{
A \code{character} vector or a \code{list} of \code{character} vectors.
}
\description{
This function will return neighbouring faces of the input faces.
}
\examples{
g <- trigrid(3)
ne <- vicinity(g, c("F4", "F10"))
ne

}
