% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spherical.R
\name{chullsphere}
\alias{chullsphere}
\title{Spherical convex hull.}
\usage{
chullsphere(
  data,
  center = c(0, 0, 0),
  radius = authRadius,
  param = 200,
  strict = TRUE
)
}
\arguments{
\item{data}{(\code{numeric}) Matrix, XYZ or longitude-latitude coordinates of the set of points.}

\item{center}{(\code{numeric}) Vector, The center of the sphere in XYZ coordinates (default is 0,0,0).}

\item{radius}{(\code{numeric}) Single value, indicating the radius of the sphere. Defaults to the R2 radius of Earth (6371.007km).}

\item{param}{(\code{numeric}) Single positive integer, indicates the number of divisions in the centroid projection method. The higher the number, the closer the replacement points are to the centroid.}

\item{strict}{(\code{logical}) Strictly convex output is required.}
}
\value{
The indices of the data points forming the convex hull as a (\code{numeric}) vector.
}
\description{
This function calculates a possible implementation of the spherical convex hull.
}
\details{
With the method \code{centroidprojection} the function calls the \code{\link{surfacecentroid}} 
function to get the a reference point from the shape. Then all the points are 'projected' 
close to this point using the great circles linking them to the reference point.
Each such great circle will be devided to an equal number of points and the closest
 will replace the original point coordinates in the convex hull algorithm implemented in \code{\link[grDevices]{chull}}.
}
\examples{
# generate some random points
allData <- rpsphere(1000)
# select only a subset
points<-allData[allData[,1]>3000,]
chullsphere(points)


}
