% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrbasicdatamono.R
\docType{data}
\name{chrbasicdatamono}
\alias{chrbasicdatamono}
\alias{dfOfChrSize}
\alias{bigdfOfChrSize}
\alias{humChr}
\alias{allChrSizeSample}
\alias{parentalAndHybChrSize}
\alias{traspadf}
\title{Chr. basic data Monocen.}
\format{
data.frame with columns:
\describe{
\item{OTU}{OTU, species, optional if only one OTU (species)}
\item{chrName}{name of chromosome}
\item{shortArmSize}{size of short arm, micrometers }
\item{longArmSize}{size of long arm, micrometers }
\item{group}{chr group, optional}
}

An object of class \code{data.frame} with 50 rows and 4 columns.

An object of class \code{data.frame} with 24 rows and 4 columns.

An object of class \code{data.frame} with 75 rows and 4 columns.

An object of class \code{data.frame} with 13 rows and 4 columns.

An object of class \code{data.frame} with 12 rows and 4 columns.
}
\source{
\url{http://www.pathology.washington.edu/research/cytopages/idiograms/human/}
}
\usage{
dfOfChrSize

bigdfOfChrSize

humChr

allChrSizeSample

parentalAndHybChrSize

traspadf
}
\description{
dfOfChrSize: Example data for monocentrics

bigdfOfChrSize: Example data for monocentrics for several species, OTU

humChr: Data for human karyotype, measured from Adler (1994)

allChrSizeSample: Example data for monocentrics for several species, OTU

parentalAndHybChrSize: Example data for monocentrics for GISH

traspadf: Example data for Tradescantia (Rhoeo) spathacea (Golczyk et al. 2005)
}
\references{
Adler 1994. Idiogram Album. \url{http://www.pathology.washington.edu/research/cytopages/idiograms/human/}

Golczyk H, Hasterok R, Joachimiak AJ (2005) FISH-aimed karyotyping and characterization of Renner complexes in permanent heterozygote Rhoeo spathacea. Genome 48:145–153.
}
\seealso{
\code{\link{plotIdiograms}}

\code{\link{armRatioCI}}

\code{\link{asymmetry}}

\code{\link{markposDFs}}
}
\keyword{datasets}
