% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uuid.R
\name{uuid}
\alias{uuid}
\title{Generate UUIDs}
\usage{
uuid(n = 1, drop_hyphens = FALSE, use_time = NA)
}
\arguments{
\item{n}{number of ids to return.  If \code{NULL}, it instead
returns the generating function}

\item{drop_hyphens}{Drop the hyphens from the UUID?}

\item{use_time}{Passed through to \code{UUIDgenerate} as \code{use.time}.}
}
\description{
Generate UUIDs using the uuid package.  This is simply a thin
wrapper around \code{uuid::UUIDgenerate} that matches the interface
in the rest of the ids package.
}
\examples{
# Generate one id
uuid()

# Or a bunch
uuid(10)

# More in the style of random_id()
uuid(drop_hyphens = TRUE)
}
\author{
Rich FitzJohn
}

