% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lat_long2state.R
\encoding{UTF-8}
\name{lat_long2state}
\alias{lat_long2state}
\title{United States of America (USA) State Identification Using Latitude/Longitude Coordinates}
\source{
Latitude Longitude Coordinates to State Code in R - Stack Overflow answered by Josh O'Brien on Jan 6 2012 and edited by Josh O'Brien on Jun 18, 2020. See \url{https://stackoverflow.com/questions/8751497/latitude-longitude-coordinates-to-state-code-in-r}.
}
\usage{
lat_long2state(latitude, longitude)
}
\arguments{
\item{latitude}{numeric vector (or character vector with numbers only) that
contains the latitude as a decimal degree}

\item{longitude}{numeric vector (or character vector with numbers only) that
contains the longitude as a decimal degree}
}
\value{
the location name as a character vector (United States of America
   (USA) state/commonwealth, Puerto Rico, or the U.S. Virgin Islands
}
\description{
Using the provided latitude/longitude coordinates (as character or numeric
vectors), this function determines whether the location is within an United
States of America (USA) state/commonwealth, Puerto Rico, or the U.S. Virgin
Islands
}
\examples{

# Example 1

library("iemisc")

lat_long2state(latitude = c(36.3684553, 40), longitude = c(-82.1796880, -89))
lat_long2state(latitude = "36.3684553", longitude = "-82.1796880")



# Example 2

# Test the function using points in Wisconsin and Oregon (From Source 1)

library("iemisc")

x = c(-90, -120); y = c(44, 44)
lat_long2state(latitude = y, longitude = x)




}
\author{
Irucka Embry, Josh O'Brien (Stack Overflow R code)
}
