% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{cotd}
\alias{cotd}
\title{Cotangent (in degrees) [GNU Octave/MATLAB compatible]}
\usage{
cotd(x)
}
\arguments{
\item{x}{A numeric vector containing values in degrees}
}
\value{
The inverse secant of each element of \code{x} in degrees.
}
\description{
Calculates the value of inverse secant for each element of \code{x} in
degrees in a manner compatible with GNU Octave/MATLAB.
}
\examples{

library(iemisc)

# Examples from GNU Octave cotd
cotd (seq(0, 80, by = 10))

cotd (c(0, 180, 360))

cotd (c(90, 270))



}
\references{
John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 554.
}
\author{
David Bateman (GNU Octave cotd), Irucka Embry
}
