#' Greenhouse Gases -- Percent Contribution to Total Greenhouse Effect (NASA)
#'
#' A table containing the percent contribution to the total greenhouse effect.
#'
#'
#'
#' @format A data.table data frame with 4 rows and 3 variables:
#' \describe{
#' \item{Gas_Name}{Name of the gas}
#' \item{Gas_Formula}{Chemical formula of the gas}
#' \item{Greenhouse Gas Contributions (approximate percent values)}{Individual greenhouse contribution by percent}
#' }
#'
#'
#' @source
#' NASA Goddard Space Flight Center: EOS Project Science Office: Earth Observatory. Jun 16, 2011, "Effects of Changing the Carbon Cycle", \url{https://web.archive.org/web/20240328160004/https://earthobservatory.nasa.gov/features/CarbonCycle/page5.php}.  [Recovered with the Internet Archive: Wayback Machine]
#'
#'
#'
#'
#'
#'
"greenhouse_gases_contributions"
#> [1] "greenhouse_gases_contributions"
