% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mage.R
\name{mage}
\alias{mage}
\title{Calculate Mean Amplitude of Glycemic Excursions}
\usage{
mage(data, sd_multiplier = 1)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{sd_multiplier}{A numeric value that can change the sd value used
to determine size of glycemic excursions used in the calculation.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding MAGE value is returned. If a vector of glucose
values is passed, then a tibble object with just the MAGE value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function mage produces MAGE values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for the MAGE values is returned. NA glucose values are
omitted from the calculation of MAGE.

MAGE is calculated by taking the mean of absolute differences (between
each value and the mean) that are greater than the standard deviation.
A multiplier can be added to the standard deviation by the sd_multiplier
argument.
}
\examples{

data(example_data_1_subject)
mage(example_data_1_subject)
mage(example_data_1_subject, sd_multiplier = 2)

data(example_data_5_subject)
mage(example_data_5_subject, sd_multiplier = .9)

}
\references{
Service et al. (1970) Mean amplitude of glycemic excursions, a
measure of diabetic instability
\emph{Diabetes}  \strong{19} .644-655,
\doi{10.2337/diab.19.9.644}.
}
