% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_roc.R
\name{sd_roc}
\alias{sd_roc}
\title{Calculate the standard deviation of the rate of change}
\usage{
sd_roc(data, timelag = 15, dt0 = NULL, inter_gap = 45, tz = "")
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{timelag}{Integer indicating the time period (# minutes) over which rate
of change is calculated. Default is 15, e.g. rate of change is the change in
glucose over the past 15 minutes divided by 15.}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}
}
\value{
A tibble object with two columns: subject id and standard deviation
of the rate of change values for each subject.
}
\description{
The function sd_roc produces the standard deviation of the rate of change
values in a tibble object.
}
\details{
A tibble object with one row for each subject, a column for subject id
and a column for the standard deviation of the rate of change.

When calculating rate of change, missing values will be linearly interpolated
when close enough to non-missing values.

Calculated by taking the standard deviation of all the ROC values for each
individual subject. NA rate of change values are omitted from the
standard deviation calculation.
}
\examples{

data(example_data_1_subject)
sd_roc(example_data_1_subject)
sd_roc(example_data_1_subject, timelag = 10)

data(example_data_5_subject)
sd_roc(example_data_5_subject)
sd_roc(example_data_5_subject, timelag = 10)

}
\references{
Clarke et al. (2009) Statistical Tools to Analyze Continuous Glucose Monitor Data,
Diabetes
\emph{Diabetes Technology and Therapeutics} \strong{11} S45-S54,
\doi{10.1089/dia.2008.0138}.
}
\author{
Elizabeth Chun, David Buchanan
}
