% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_glu.R
\name{quantile_glu}
\alias{quantile_glu}
\title{Calculate glucose level quantiles}
\usage{
quantile_glu(data, quantiles = c(0, 25, 50, 75, 100))
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{quantiles}{List of quantile values between 0 and 100.}
}
\value{
If a DataFrame object is passed, then a tibble object with
a column for subject id and then a column for each quantile value is returned. If a vector of glucose
values is passed, then a tibble object without the subject id is returned.
\code{as.numeric()} can be wrapped around the latter to output a numeric vector.
}
\description{
The function \code{quantile_glu} is a wrapper for the base function \code{quantile()}. Output
is a tibble object with columns for subject id and each of the quantiles.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for each quantile is returned. \code{NA} glucose values are
omitted from the calculation of the quantiles.

The values are scaled from 0-1 to 0-100 to be consistent in output with
above_percent, below_percent, and in_range_percent.

The command \code{quantile_glu(...) / 100} will scale each element down from 0-100
to 0-1.
}
\examples{
data(example_data_1_subject)

quantile_glu(example_data_1_subject)
quantile_glu(example_data_1_subject, quantiles = c(0, 33, 66, 100))

data(example_data_5_subject)

quantile_glu(example_data_5_subject)
quantile_glu(example_data_5_subject, quantiles = c(0, 10, 90, 100))
}
