% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igo_search.R
\name{igo_search}
\alias{igo_search}
\title{Search and Find an IGO}
\usage{
igo_search(pattern = NULL, exact = FALSE)
}
\arguments{
\item{pattern}{regex pattern. If \code{NULL} the function returns a dataset
with all the IGOs on \link{igo_year_format3}. Integer values are
accepted.}

\item{exact}{Logical. When \code{TRUE} only exact matches are returned.}
}
\value{
A dataframe.
}
\description{
Search any IGO by name or string pattern.
}
\details{
The information of each IGO is retrieved based on the last year
available on \link{igo_year_format3}.

An additional column \code{label} is provided. This column is a clean
version of \code{longorgname}
}
\examples{
# All values
all <- igo_search()

nrow(all)
colnames(all)

dplyr::tibble(all)

# Search by pattern
igo_search("EU")[, 1:3]

igo_search("EU", exact = TRUE)[, 1:3]

# With integers
igo_search(10)[, 1:3]

igo_search(10, exact = TRUE)[, 1:3]

# Several patterns (regex style)
igo_search("NAFTA|UN|EU")[, 1:3]

# Several patterns Exact (regex style)
igo_search("^NAFTA$|^UN$|^EU$")[, 1:3]
}
\seealso{
\link{igo_year_format3}
}
