% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simple.R
\name{simplify}
\alias{is.simple}
\alias{is_simple}
\alias{simplify}
\title{Simple graphs}
\usage{
simplify(graph, remove.multiple = TRUE, remove.loops = TRUE,
  edge.attr.comb = igraph_opt("edge.attr.comb"))

is_simple(graph)
}
\arguments{
\item{graph}{The graph to work on.}

\item{remove.multiple}{Logical, whether the multiple edges are to be
removed.}

\item{remove.loops}{Logical, whether the loop edges are to be removed.}

\item{edge.attr.comb}{Specifies what to do with edge attributes, if
\code{remove.multiple=TRUE}. In this case many edges might be mapped to a
single one in the new graph, and their attributes are combined. Please see
\code{\link{attribute.combination}} for details on this.}
}
\value{
A new graph object with the edges deleted.
}
\description{
Simple graphs are graphs which do not contain loop and multiple edges.
}
\details{
A loop edge is an edge for which the two endpoints are the same
vertex. Two edges are multiple edges if they have exactly the same two
endpoints (for directed graphs order does matter). A graph is simple is
it does not contain loop edges and multiple edges.

\code{is_simple} checks whether a graph is simple.

\code{simplify} removes the loop and/or multiple edges from a graph.  If
both \code{remove.loops} and \code{remove.multiple} are \code{TRUE} the
function returns a simple graph.
}
\examples{
g <- graph( c(1,2,1,2,3,3) )
is_simple(g)
is_simple(simplify(g, remove.loops=FALSE))
is_simple(simplify(g, remove.multiple=FALSE))
is_simple(simplify(g))
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{which_loop}}, \code{\link{which_multiple}} and
\code{\link{count_multiple}}, \code{\link{delete_edges}},
\code{\link{delete_vertices}}
}
\keyword{graphs}

