% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{merge_coords}
\alias{merge_coords}
\alias{layout.merge}
\alias{piecewise.layout}
\alias{layout_components}
\title{Merging graph layouts}
\usage{
merge_coords(graphs, layouts, method = "dla")

layout_components(graph, layout = layout_with_kk, ...)
}
\arguments{
\item{graphs}{A list of graph objects.}

\item{layouts}{A list of two-column matrices.}

\item{method}{Character constant giving the method to use. Right now only
\code{dla} is implemented.}

\item{graph}{The input graph.}

\item{layout}{A function object, the layout function to use.}

\item{\dots}{Additional arguments to pass to the \code{layout} layout
function.}
}
\value{
A matrix with two columns and as many lines as the total number of
vertices in the graphs.
}
\description{
Place several graphs on the same layout
}
\details{
\code{merge_coords()} takes a list of graphs and a list of coordinates and
places the graphs in a common layout. The method to use is chosen via the
\code{method} parameter, although right now only the \code{dla} method is
implemented.

The \code{dla} method covers the graph with circles.  Then it sorts the
graphs based on the number of vertices first and places the largest graph at
the center of the layout. Then the other graphs are placed in decreasing
order via a DLA (diffision limited aggregation) algorithm: the graph is
placed randomly on a circle far away from the center and a random walk is
conducted until the graph walks into the larger graphs already placed or
walks too far from the center of the layout.

The \code{layout_components()} function disassembles the graph first into
maximal connected components and calls the supplied \code{layout} function
for each component separately. Finally it merges the layouts via calling
\code{merge_coords()}.
}
\examples{

# create 20 scale-free graphs and place them in a common layout
graphs <- lapply(sample(5:20, 20, replace = TRUE),
  barabasi.game,
  directed = FALSE
)
layouts <- lapply(graphs, layout_with_kk)
lay <- merge_coords(graphs, layouts)
g <- disjoint_union(graphs)
plot(g, layout = lay, vertex.size = 3, labels = NA, edge.color = "black")
}
\seealso{
\code{\link[=plot.igraph]{plot.igraph()}}, \code{\link[=tkplot]{tkplot()}},
\code{\link[=layout]{layout()}}, \code{\link[=disjoint_union]{disjoint_union()}}

Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{component_wise}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{layout_}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{graph layouts}
\keyword{graphs}
