% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_bipartite}
\alias{sample_bipartite}
\alias{bipartite}
\title{Bipartite random graphs}
\usage{
sample_bipartite(
  n1,
  n2,
  type = c("gnp", "gnm"),
  p,
  m,
  directed = FALSE,
  mode = c("out", "in", "all")
)

bipartite(...)
}
\arguments{
\item{n1}{Integer scalar, the number of bottom vertices.}

\item{n2}{Integer scalar, the number of top vertices.}

\item{type}{Character scalar, the type of the graph, \sQuote{gnp} creates a
\eqn{G(n,p)} graph, \sQuote{gnm} creates a \eqn{G(n,m)} graph. See details below.}

\item{p}{Real scalar, connection probability for \eqn{G(n,p)} graphs. Should not
be given for \eqn{G(n,m)} graphs.}

\item{m}{Integer scalar, the number of edges for \eqn{G(n,m)} graphs. Should not
be given for \eqn{G(n,p)} graphs.}

\item{directed}{Logical scalar, whether to create a directed graph. See also
the \code{mode} argument.}

\item{mode}{Character scalar, specifies how to direct the edges in directed
graphs. If it is \sQuote{out}, then directed edges point from bottom
vertices to top vertices. If it is \sQuote{in}, edges point from top
vertices to bottom vertices. \sQuote{out} and \sQuote{in} do not generate
mutual edges. If this argument is \sQuote{all}, then each edge direction is
considered independently and mutual edges might be generated. This argument
is ignored for undirected graphs.}

\item{...}{Passed to \code{sample_bipartite()}.}
}
\value{
A bipartite igraph graph.
}
\description{
Generate bipartite graphs using the Erdős-Rényi model
}
\details{
Similarly to unipartite (one-mode) networks, we can define the \eqn{G(n,p)}, and
\eqn{G(n,m)} graph classes for bipartite graphs, via their generating process.
In \eqn{G(n,p)} every possible edge between top and bottom vertices is realized
with probability \eqn{p}, independently of the rest of the edges. In \eqn{G(n,m)}, we
uniformly choose \eqn{m} edges to realize.
}
\examples{

## empty graph
sample_bipartite(10, 5, p = 0)

## full graph
sample_bipartite(10, 5, p = 1)

## random bipartite graph
sample_bipartite(10, 5, p = .1)

## directed bipartite graph, G(n,m)
sample_bipartite(10, 5, type = "Gnm", m = 20, directed = TRUE, mode = "all")

}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
