% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{common_pixsets}
\alias{common_pixsets}
\alias{px.circle}
\alias{px.diamond}
\alias{px.square}
\alias{px.left}
\alias{px.top}
\alias{px.bottom}
\alias{px.right}
\alias{px.borders}
\alias{px.all}
\alias{px.none}
\title{Various useful pixsets}
\usage{
px.circle(r, x = 2 * r + 1, y = 2 * r + 1)

px.diamond(r, x = 2 * r + 1, y = 2 * r + 1)

px.square(r, x = 2 * r + 1, y = 2 * r + 1)

px.left(im, n = 1)

px.top(im, n = 1)

px.bottom(im, n = 1)

px.right(im, n = 1)

px.borders(im, n = 1)

px.all(im)

px.none(im)
}
\arguments{
\item{r}{radius (in pixels)}

\item{x}{width (default 2*r+1)}

\item{y}{height (default 2*r+1)}

\item{im}{an image}

\item{n}{number of pixels to include}
}
\value{
a pixset
}
\description{
These functions define some commonly used pixsets.
px.left gives the left-most pixels of an image, px.right the right-most, etc.
px.circle returns an (approximately) circular pixset of radius r, embedded in an image of width x and height y
Mathematically speaking, the set of all pixels whose L2 distance to the center equals r or less.
px.diamond is similar but returns a diamond (L1 distance less than r)
px.square is also similar but returns a square (Linf distance less than r)
}
\section{Functions}{
\itemize{
\item \code{px.circle()}: A circular-shaped pixset

\item \code{px.diamond()}: A diamond-shaped pixset

\item \code{px.square()}: A square-shaped pixset

\item \code{px.left()}: n left-most pixels (left-hand border)

\item \code{px.top()}: n top-most pixels

\item \code{px.bottom()}: n bottom-most pixels

\item \code{px.right()}: n right-most pixels

\item \code{px.borders()}: image borders (to depth n)

\item \code{px.all()}: all pixels in image

\item \code{px.none()}: no pixel in image

}}
\examples{
\dontshow{cimg.limit.openmp()}
px.circle(20,350,350) \%>\% plot(interp=FALSE)
px.circle(3) \%>\% plot(interp=FALSE)
r <- 5
layout(t(1:3))
plot(px.circle(r,20,20))
plot(px.square(r,20,20))
plot(px.diamond(r,20,20))
#These pixsets are useful as structuring elements
px <- grayscale(boats) > .8
grow(px,px.circle(5)) \%>\% plot
#The following functions select pixels on the left, right, bottom, top of the image
im <- imfill(10,10)
px.left(im,3) \%>\% plot(int=FALSE)
px.right(im,1) \%>\% plot(int=FALSE)
px.top(im,4) \%>\% plot(int=FALSE)
px.bottom(im,2) \%>\% plot(int=FALSE)
#All of the above
px.borders(im,1) \%>\% plot(int=FALSE)
}
\author{
Simon Barthelme
}
