% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R
\name{extr_biodescr}
\alias{extr_biodescr}
\title{Extract Biological descriptor}
\usage{
extr_biodescr(
  BasicData,
  geneset = c("kegg", "mkegg", "go", "wp"),
  arguments = list(minGSSize = 5, maxGSSize = 500, pvalue = 0.05, qvalue = 0.1),
  ref_type = "drug",
  ref = NULL,
  to_ENTREZID = TRUE
)
}
\arguments{
\item{BasicData}{BasicData object.}

\item{geneset}{Charactor vector, one of "kegg"(KEGG), "mkegg"(KEGG Module), "go"(GO-BP), and "wp"(WikiPathways); a data frame and list.}

\item{arguments}{A list of the arguments of \code{clusterProfiler}, including \code{minGSSize}, \code{maxGSSize}, \code{pvalue}, and \code{qvalue}.}

\item{ref_type}{Charactor vector, one of "drug", "herb", "compound" or "target", defaults to "drug".}

\item{ref}{Charactor vector, reference drug, herb, compound or target, defaults to \code{NULL}.}

\item{to_ENTREZID}{Logical, whether to translate to ENTREZID from SYMBOL, defaults to TRUE.}
}
\value{
A BioDescr object.
}
\description{
Extract Biological descriptor
}
\author{
Yuanlong Hu
}
