% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectratyping.R
\name{spectratype}
\alias{spectratype}
\title{Immune repertoire spectratyping}
\usage{
spectratype(.data, .quant = c("id", "count"), .col = "nt")
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from \link{copy_to} or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.quant}{Select the column with clonal counts to evaluate. Pass "id" to count every clonotype once.
Pass "count" to take into the account number of clones per clonotype.}

\item{.col}{A string that specifies the column(s) to be processed. Pass one of the
following strings, separated by the plus sign: "nt" for nucleotide sequences,
"aa" for amino acid sequences, "v" for V gene segments, "j" for J gene segments. E.g.,
pass "aa+v" for spectratyping on CDR3 amino acid sequences paired with V gene segments, i.e.,
in this case a unique clonotype is a pair of CDR3 amino acid and V gene segment.
Clonal counts of equal clonotypes will be summed up.}
}
\value{
Data frame with distributions of clonotypes per CDR3 length.
}
\description{
Immune repertoire spectratyping
}
\examples{
# Load the data
data(immdata)
sp <- spectratype(immdata$data[[1]], .col = "aa+v")
vis(sp)
}
\concept{vis}
