% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_dynamics}
\alias{vis.immunr_dynamics}
\title{Visualise clonotype dynamics}
\usage{
\method{vis}{immunr_dynamics}(.data, .plot = c("smooth", "area", "line"), .order = NA, .log = FALSE, ...)
}
\arguments{
\item{.data}{Output from the \link{trackClonotypes} function.}

\item{.plot}{Character. Either "smooth", "area" or "line". Each specifies a type of plot for visualisation of clonotype dynamics.}

\item{.order}{Numeric or character vector. Specifies the order to samples, e.g., it used for ordering samples
by timepoints. Either See "Examples" below for more details.}

\item{.log}{Logical. If TRUE then use log-scale for the frequency axis.}

\item{...}{Not used here.}
}
\value{
A ggplot2 object.
}
\description{
Visualise clonotype dynamics
}
\examples{
# Load an example data that comes with immunarch
data(immdata)

# Make the data smaller in order to speed up the examples
immdata$data <- immdata$data[c(1, 2, 3, 7, 8, 9)]
immdata$meta <- immdata$meta[c(1, 2, 3, 7, 8, 9), ]

# Option 1
# Choose the first 10 amino acid clonotype sequences
# from the first repertoire to track
tc <- trackClonotypes(immdata$data, list(1, 10), .col = "aa")
# Choose the first 20 nucleotide clonotype sequences
# and their V genes from the "MS1" repertoire to track
tc <- trackClonotypes(immdata$data, list("MS1", 20), .col = "nt+v")

# Option 2
# Choose clonotypes with amino acid sequences "CASRGLITDTQYF" or "CSASRGSPNEQYF"
tc <- trackClonotypes(immdata$data, c("CASRGLITDTQYF", "CSASRGSPNEQYF"), .col = "aa")

# Option 3
# Choose the first 10 clonotypes from the first repertoire
# with amino acid sequences and V segments
target <- immdata$data[[1]] \%>\%
  select(CDR3.aa, V.name) \%>\%
  head(10)
tc <- trackClonotypes(immdata$data, target)

# Visualise the output regardless of the chosen option
# Therea are three way to visualise it, regulated by the .plot argument
vis(tc, .plot = "smooth")
vis(tc, .plot = "area")
vis(tc, .plot = "line")

# Visualising timepoints
# First, we create an additional column in the metadata with randomly choosen timepoints:
immdata$meta$Timepoint <- sample(1:length(immdata$data))
immdata$meta
# Next, we create a vector with samples in the right order,
# according to the "Timepoint" column (from smallest to greatest):
sample_order <- order(immdata$meta$Timepoint)
# Sanity check: timepoints are following the right order:
immdata$meta$Timepoint[sample_order]
# Samples, sorted by the timepoints:
immdata$meta$Sample[sample_order]
# And finally, we visualise the data:
vis(tc, .order = sample_order)
}
\concept{dynamics}
