% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_immundata.R
\name{load_immundata}
\alias{load_immundata}
\title{Load a Saved ImmunData Object from Disk}
\usage{
load_immundata(path, verbose = TRUE)
}
\arguments{
\item{path}{Path to the folder containing the saved ImmunData files.}

\item{verbose}{Logical. If \code{TRUE} (default), prints progress messages to the console.}
}
\value{
A new \code{ImmunData} object containing receptor and annotation data.
}
\description{
Loads an \code{ImmunData} object from a directory created by Immundata I/O functions
(e.g., \code{load_repertoires()} with file splitting or saving). It reads receptor-level
and annotation-level data from standardized Parquet files and reconstructs a
new \code{ImmunData} object with inferred schema.

This function expects two files inside the provided directory:
\itemize{
\item \code{receptors.parquet}: contains the receptor-level table
\item \code{annotations.parquet}: contains the annotation-level table
}

These filenames are defined in \code{imd_files()} and follow the Immundata storage convention.
}
\seealso{
\code{\link[=imd_files]{imd_files()}}, \link{ImmunData}, \code{\link[duckplyr:read_parquet_duckdb]{duckplyr::read_parquet_duckdb()}}
}
