% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations_agg.R
\name{make_receptor_schema}
\alias{make_receptor_schema}
\alias{assert_receptor_schema}
\alias{test_receptor_schema}
\title{Create or validate a receptor schema object}
\usage{
make_receptor_schema(features, chains = NULL)

assert_receptor_schema(schema)

test_receptor_schema(schema)
}
\arguments{
\item{features}{Character vector. Column names defining the features of a
single receptor chain (e.g., V gene, J gene, CDR3 sequence).}

\item{chains}{Optional character vector (max length 2). Locus names (e.g.,
\code{"TRA"}, \code{"TRB"}) to filter by or pair. If \code{NULL} or length 1, only
filtering occurs. If length 2, pairing logic is enabled in \code{\link[=agg_receptors]{agg_receptors()}}.
Default: \code{NULL}.}

\item{schema}{An object to test or assert as a valid schema. Can be a list
created by \code{make_receptor_schema} or a character vector (for \code{test_receptor_schema}).}
}
\value{
\code{make_receptor_schema} returns a list with elements \code{features} and \code{chains}.
\code{assert_receptor_schema} returns \code{TRUE} invisibly if valid, or stops execution.
\code{test_receptor_schema} returns \code{TRUE} or \code{FALSE}.
}
\description{
Helper functions for defining and validating the \code{schema} used by
\code{\link[=agg_receptors]{agg_receptors()}} to identify unique receptors.

\code{make_receptor_schema()} creates a schema list object.
\code{assert_receptor_schema()} checks if an object is a valid schema list and throws
an error if not.
\code{test_receptor_schema()} checks if an object is a valid schema list or a
character vector (which \code{agg_receptors} can also accept) and returns \code{TRUE}
or \code{FALSE}.
}
\concept{utils}
