% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_density.R
\name{d_density}
\alias{d_density}
\title{Plot IAT or SC-IAT scores (distribution)}
\usage{
d_density(
  data,
  graph = c("histogram", "density", "violin"),
  n_bin = 80,
  col_fill = "royalblue",
  col_point = "red",
  include_stats = FALSE
)
}
\arguments{
\item{data}{Dataframe with either class \code{dscore} or \code{dsciat}.}

\item{graph}{String. Indicates the graphs to display. Default is
\code{histogram}}

\item{n_bin}{Numeric. Indicates the number of bins to display.}

\item{col_fill}{String. Indicates the color for filling the bars of the
\code{histogram} or the curve of the \code{density}. Default
is \code{royalblue}.}

\item{col_point}{String. Indicates the color for the individual scores --each
point -- in the violin plot. Default is \code{red}.}

\item{include_stats}{Logical. Indicates whether to add descriptive statistics.
The \code{mean} is depicted with a solid line. The two
dashed lines represent +/- 2 \emph{s.d.} from the mean.
Default is \code{FALSE}.}
}
\value{
A ggplot object.
}
\description{
Plot the distribution of the IAT \emph{D-score} or the SC-IAT \emph{D}.
}
\examples{
\donttest{
  # Plotting the IAT D-score
  data("raw_data") # import data
  iat_cleandata <- clean_iat(raw_data, sbj_id = "Participant",
                          block_id = "blockcode",
                          mapA_practice = "practice.iat.Milkbad",
                          mapA_test = "test.iat.Milkbad",
                          mapB_practice = "practice.iat.Milkgood",
                          mapB_test = "test.iat.Milkgood",
                          latency_id = "latency",
                          accuracy_id = "correct",
                          trial_id = "trialcode",
                          trial_eliminate = c("reminder", "reminder1"),
                          demo_id = "blockcode",
                          trial_demo = "demo")
  iat_data <- iat_cleandata[[1]]
# calculate D-score
  iat_dscore <- compute_iat(iat_data,
                       Dscore =  "d2")
  d_density(iat_dscore) # Default graph
  d_density(iat_dscore, graph = "histogram",
          n_bin = 30) # Histogram with a different number of bins
  d_density(iat_dscore, graph = "density") # IAT D-score density plot
  d_density(iat_dscore, graph = "violin") # IAT D-score violin plot

  # Plot the SC-IAT D for the first SC-IAT
  data("raw_data") # load data
  sciat_data <- clean_sciat(raw_data, sbj_id = "Participant",
                         block_id = "blockcode",
                         latency_id = "latency",
                         accuracy_id = "correct",
                         block_sciat_1 = c("test.sc_dark.Darkbad",
                                           "test.sc_dark.Darkgood"),
                         block_sciat_2 = c("test.sc_milk.Milkbad",
                                           "test.sc_milk.Milkgood"),
                         trial_id  = "trialcode",
                         trial_eliminate = c("reminder",
                                             "reminder1"))

 sciat1 <- sciat_data[[1]] # compute D for the first SC-IAT
 d_sciat1 <- compute_sciat(sciat1,
                  mappingA = "test.sc_dark.Darkbad",
                  mappingB = "test.sc_dark.Darkgood",
                  non_response = "alert")
  d_density(d_sciat1, graph = "histogram",
          include_stats = TRUE) # SC-IAT D histogram with descriptive
                                   #  statistics
                                   }
}
