% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.Dates.R
\name{as.Dates}
\alias{as.Dates}
\title{Converting potential date to Date vector}
\usage{
as.Dates(x)
}
\arguments{
\item{x}{atomic vector}
}
\value{
vector of class "Date"
}
\description{
The function recognizes dates in formats used by INCA and Rockan.
}
\details{
Regular expressions are used to match any of the following date formats:
\itemize{ \item \code{Y-m-d}: The ISO 8601 standard such as "2017-02-16" as
used by INCA. \item \code{Ymd}: such as "20160216" as used by the Rockan
registers \item Any of the above with missing day such as "2017-02-00" or
"20170200" as used if the exact date is unknown. \item Any of the above with
missing month such as "2017-00-00" or "20170000" as sometimes used if the
exact date is unknown. \item Dates between 1950 and 1980 can have missing
century prefix, such as "67-01-01", "670101", "670100", "670000" etc as
earlier used for some dates in the Rockan registers. \item Dates from the
20th century can also have month and day changed to week number such as
"6723" or "196723" as sometimes used for death dates in the cancer register
(originating from the population register). \item The special INCA variable
\code{SKAPAD_DATUM} is also recognized as data but is originally a date and
time object (\code{\link{POSIXct}} }

All dates are coerced to \code{Y-m-d} (ISO 8601): \itemize{ \item a missing
day is set to 15 \item a missing month is set to July \item a week number is
translated to the "median day" of that week \item \code{SKAPAD_DATUM} has its
time stamp dropped } An alternative would be to use random assignments of
dates within specified periods. This would have some benefits but does not
conform to behavior used elsewhere by INCA.
}
\section{Possible date range}{


  All potential dates are accepted as such. RCC data should however only
  contain historic data. Dates from the future does therefore raise warnings.
  The same is true for dates before 1830. The Swedish cancer register was
  initiated in 1958. The earliest possible dates found in the register should
  therefore originate from birth date of really old people diagnosed with
  cancer during that year.
}

\examples{

as.Dates(c(1212121212, "20000101", "2014-10-15", 5806))

\dontrun{
# Note that the as.Date (as oppose to as.Dates)
# does not handle missing dates as empty strings
as.Date(c("", "2017-02-16")) # Error
as.Dates(c("", "2017-02-16")) # NA "2017-02-16"
}
}
\seealso{
\link{as.Date}
}
