% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulate.R
\name{cumulate}
\alias{cumulate}
\title{Compute cumulative 'incidence'}
\usage{
cumulate(x)
}
\arguments{
\item{x}{\link[=incidence]{incidence2} object.}
}
\description{
\code{cumulate()} computes the cumulative incidence over time for an
\link[=incidence]{incidence2} object.
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
dat <- data.frame(
  dates = as.integer(c(0,1,2,2,3,5,7)),
  groups = factor(c(1, 2, 3, 3, 3, 3, 1))
)

i <- incidence(dat, date_index = "dates", groups = "groups")
cumulate(i)
\dontshow{data.table::setDTthreads(.old)}

}
