% Generated by roxygen2 (4.0.2): do not edit by hand
\name{face_features}
\alias{face_features}
\title{Detects face features}
\usage{
face_features(img, local.api = FALSE)
}
\arguments{
\item{img}{image data}

\item{local.api}{logical, whether use local or remote API}
}
\value{
List with face features
}
\description{
Given an grayscale input image of a face, returns a 48 dimensional feature vector explaining that face.
Useful as a form of feature engineering for face oriented tasks.
Input should be in a list of list format, resizing will be attempted internally but for best
performance, images should be already sized at 48x48 pixels.
}
\examples{
img <- matrix(runif(48*48, 0, 1), nrow = 48)
features <- face_features(img)
length(features)
}
\seealso{
\code{\link{face_emotion}}, \code{\link{image_features}}
}
\keyword{API}
\keyword{face}
\keyword{features}
\keyword{indico.io}
\keyword{learning}
\keyword{machine}
\keyword{recognition}

