% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elicit_functions.R
\name{designLink}
\alias{designLink}
\title{Create list with information for the elicitation session}
\usage{
designLink(design, link = "identity", target = "Target", CI.prob = 1/2,
  expertID = "Expert", facilitator = "Facilitator", rapporteur = "none",
  intro.comments = "This is a record of the elicitation session.")
}
\arguments{
\item{design}{a dataframe with covariate values that will be displayed
to the expert(s) during the elicitation session.}

\item{link}{character \code{logit}, \code{log}, \code{cloglog}, 
\code{identity}}

\item{target}{character, name of target parameter of elicitation exercise}

\item{CI.prob}{numeric, a fraction between 0 and 1 that defines probability 
attributed to central credible interval. For example, 1/2 for a central credible interval
of probability 0.5, or 1/3 for a central credible interval of probablity
0.333... The default is 1/2}

\item{expertID}{character, identifier for expert or group of experts}

\item{facilitator}{character, facilitator identifier}

\item{rapporteur}{character, rapporteur identifier. Default "none".}

\item{intro.comments}{character, text with any prefacing comments. Beware of 
non-ASCII text and special characters, which may affect ability to render 
the likes of Sweave, knitr, markdown, etc.}
}
\value{
list of \code{design} with entries: \code{theta}, a \eqn{n x 4} 
  matrix with columns that give lower, median and upper quantiles followed by
  \code{CI.prob}; \code{link}, the link function used; \code{target}; 
  \code{expert} \code{facilitator}; \code{rapporteur}; \code{date}; 
  \code{intro.comments}.
}
\description{
This builds the structure that will store elicited data. The linear predictor
has a normal prior \eqn{g(\theta) ~ N(m, V)}, \eqn{\theta} is the elicitation
target. Link functions \eqn{g(.)}: \code{logit}, \code{log}, \code{cloglog}, 
\code{identity}.
}
\details{
Assumption: at least two of median and upper and lower bound of central 
credible interval of probability \code{CI.prob} is elicited at each design 
point. The probabilities assigned to the central credible intervals  can vary
across design points.  \code{CI.prob} may vary by design point during the
elicitation exercise. In the first instance, it is set to a global value
specified by \code{CI.prob} with default value \eqn{0.5}.
#'
}
\examples{
X <- matrix(c(1, 1, 0, 1), nrow = 2) # design
Z <- designLink(design = X, link = "logit", target = "target",
 CI.prob = 1/2, expertID = "Expert", facilitator = "facilitator")
}
