% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inferCSN.R
\docType{methods}
\name{inferCSN}
\alias{inferCSN}
\alias{inferCSN,matrix-method}
\alias{inferCSN,data.frame-method}
\title{Inferring Cell-Specific Gene Regulatory Network}
\usage{
inferCSN(object, ...)

\S4method{inferCSN}{matrix}(
  object,
  penalty = "L0",
  algorithm = "CD",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 10,
  k_folds = NULL,
  r_threshold = 0,
  regulators = NULL,
  targets = NULL,
  regulators_num = NULL,
  verbose = FALSE,
  cores = 1,
  ...
)

\S4method{inferCSN}{data.frame}(
  object,
  penalty = "L0",
  algorithm = "CD",
  cross_validation = FALSE,
  seed = 1,
  n_folds = 10,
  k_folds = NULL,
  r_threshold = 0,
  regulators = NULL,
  targets = NULL,
  regulators_num = NULL,
  verbose = FALSE,
  cores = 1,
  ...
)
}
\arguments{
\item{object}{Input object}

\item{...}{Arguments passed to other methods}

\item{penalty}{The type of regularization.
This can take either one of the following choices: "L0" and "L0L2".
For high-dimensional and sparse data, such as single-cell sequencing data, "L0L2" is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function.
Currently "CD" and "CDPSI" are supported.
The CDPSI algorithm may yield better results, but it also increases running time.}

\item{cross_validation}{Check whether cross validation is used.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{n_folds}{The number of folds for cross-validation.}

\item{k_folds}{The number of folds for sample split.}

\item{r_threshold}{Threshold of R^2.}

\item{regulators}{Regulator genes.}

\item{targets}{Target genes.}

\item{regulators_num}{The number of non-zore coef, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{verbose}{Print detailed information.}

\item{cores}{CPU cores.}
}
\value{
A data table of gene-gene regulatory relationship
}
\description{
Inferring Cell-Specific Gene Regulatory Network
}
\examples{
library(inferCSN)
data("example_matrix")
weight_table <- inferCSN(example_matrix, verbose = TRUE)
head(weight_table)

weight_table <- inferCSN(example_matrix, verbose = TRUE, cores = 2)
head(weight_table)
}
