% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_evaluation.R
\name{calculate_auc}
\alias{calculate_auc}
\title{Calculate AUPRC and AUROC values}
\usage{
calculate_auc(
  network_table,
  ground_truth,
  plot = FALSE,
  line_color = "#1563cc",
  line_width = 1
)
}
\arguments{
\item{network_table}{The weight data table of network}

\item{ground_truth}{Ground truth for calculate AUC}

\item{plot}{If true, draw and print figure of AUC}

\item{line_color}{The color of line in the figure}

\item{line_width}{The width of line in the figure}
}
\value{
AUC values and figure
}
\description{
Calculate AUPRC and AUROC values
}
\examples{
data("example_matrix")
data("example_ground_truth")
network_table <- inferCSN(example_matrix)
calculate_auc(network_table, example_ground_truth, plot = TRUE)
}
