% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisquare-gof.R
\name{chisq_gof}
\alias{chisq_gof}
\title{Chi Square Goodness of Fit Test}
\usage{
chisq_gof(x, y, correct = FALSE)
}
\arguments{
\item{x}{categorical variable}

\item{y}{expected proportions}

\item{correct}{logical; if TRUE continuity correction is applied}
}
\value{
\code{chisq_gof} returns an object of class \code{"chisq_gof"}.
An object of class \code{"chisq_gof"} is a list containing the
following components:

\item{chisquare}{chi square statistic}
\item{pvalue}{p-value}
\item{df}{chi square degrees of freedom}
\item{ssize}{number of observations}
\item{names}{levels of \code{x}}
\item{level}{number of levels of \code{x}}
\item{obs}{observed frequency/proportion}
\item{exp}{expected frequency/proportion}
\item{deviation}{deviation of observed from frequency}
\item{std}{standardized residuals}
\item{varname}{name of categorical variable}
}
\description{
Test whether the observed proportions for a categorical variable
differ from hypothesized proportions
}
\examples{
chisq_gof(as.factor(hsb$race), c(20, 20, 20, 140))

# apply continuity correction
chisq_gof(as.factor(hsb$race), c(20, 20, 20, 140), correct = TRUE)
}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{chisq.test}}
}

