% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{h_index}
\alias{h_index}
\alias{h.index}
\title{H-index}
\usage{
h_index(graph, vertices = V(graph), mode = "all", verbose = FALSE)
}
\arguments{
\item{graph}{A graph (network) of the igraph class.}

\item{vertices}{A vector of desired vertices, which could be obtained by the V function.}

\item{mode}{The mode of H-index depending on the directedness of the graph.
If the graph is undirected, the mode "all" should be specified.
Otherwise, for the calculation of H-index based on
incoming connections select "in" and for the outgoing connections select "out".
Also, if all of the connections are desired, specify the "all" mode. Default mode is set to "all".}

\item{verbose}{Logical; whether the accomplishment of different stages of the algorithm should be printed (default is FALSE).}
}
\value{
A vector including the H-index of each vertex inputted.
}
\description{
This function calculates the H-index of input vertices and
works with both directed and undirected networks.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
h.index <- h_index(graph = My_graph, vertices = GraphVertices, mode = "all")
}
}
\seealso{
\code{\link[influential]{ivi}},
\code{\link[influential]{cent_network.vis}}

Other centrality functions: 
\code{\link{betweenness}()},
\code{\link{clusterRank}()},
\code{\link{collective.influence}()},
\code{\link{degree}()},
\code{\link{lh_index}()},
\code{\link{neighborhood.connectivity}()},
\code{\link{sirir}()}
}
\concept{centrality functions}
\keyword{h_index}
