% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ceteris_paribus_oscillations.R
\name{plot.ceteris_paribus_oscillations}
\alias{plot.ceteris_paribus_oscillations}
\title{Plot Ceteris Paribus Oscillations}
\usage{
\method{plot}{ceteris_paribus_oscillations}(x, ..., bar_width = 10)
}
\arguments{
\item{x}{a ceteris paribus oscillation explainer produced with function \code{calculate_oscillations()}}

\item{...}{other explainers that shall be plotted together}

\item{bar_width}{width of bars. By default \code{10}.}
}
\value{
a \code{ggplot2} object
}
\description{
This function plots local variable importance plots
calculated as oscillations in the Ceteris Paribus Profiles.
}
\examples{
\donttest{
library("DALEX")
library("randomForest")

apartments_rf_model <- randomForest(m2.price ~., data = apartments)

explainer_rf <- explain(apartments_rf_model,
                        data = apartments_test[,-1],
                        y = apartments_test[,1])

apartment <- apartments_test[1:2,]

cp_rf <- ceteris_paribus(explainer_rf, apartment)
plot(cp_rf, color = "_ids_")

vips <- calculate_oscillations(cp_rf)
vips

plot(vips)
}

}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
