% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{bru_log_bookmark}
\alias{bru_log_bookmark}
\alias{bru_log_bookmarks}
\title{Methods for \code{bru_log} bookmarks}
\usage{
bru_log_bookmark(bookmark = "", offset = NULL, x = NULL)

bru_log_bookmarks(x = NULL)
}
\arguments{
\item{bookmark}{character; The label for a bookmark with a stored offset.}

\item{offset}{integer; a position offset in the log, with \code{0L} pointing at
the start of the log. If negative, denotes the point \code{abs(offset)} elements
from tail of the log. When \code{bookmark} is non-NULL, the \code{offset} applies a
shift (forwards or backwards) to the bookmark list.}

\item{x}{A \code{bru_log} object. If \code{NULL}, the global \code{inlabru} log is used.}
}
\value{
\code{bru_log_bookmark()}: Returns the modified \code{bru_log} object if \code{x}
is non-NULL.

\code{bru_log_bookmarks()}: Returns the bookmark vector associated with
\code{x}
}
\description{
Methods for \code{bru_log} bookmarks.
}
\section{Functions}{
\itemize{
\item \code{bru_log_bookmark()}: Set a log bookmark. If \code{offset} is \code{NULL} (the default),
the bookmark will point to the current end of the log.

\item \code{bru_log_bookmarks()}: Return a integer vector with named elements
being bookmarks into the global \code{inlabru} log with associated log position
offsets.

}}
\seealso{
Other inlabru log methods: 
\code{\link{bru_log}()},
\code{\link{bru_log_message}()},
\code{\link{bru_log_new}()},
\code{\link{bru_log_offset}()},
\code{\link{bru_log_reset}()}
}
\concept{inlabru log methods}
