% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{component}
\alias{component}
\alias{bru_component}
\alias{component.character}
\title{Latent model component construction}
\usage{
component(...)

\method{component}{character}(
  object,
  main = NULL,
  weights = NULL,
  ...,
  model = NULL,
  mapper = NULL,
  main_layer = NULL,
  main_selector = NULL,
  n = NULL,
  values = NULL,
  season.length = NULL,
  copy = NULL,
  weights_layer = NULL,
  weights_selector = NULL,
  group = NULL,
  group_mapper = NULL,
  group_layer = NULL,
  group_selector = NULL,
  ngroup = NULL,
  control.group = NULL,
  replicate = NULL,
  replicate_mapper = NULL,
  replicate_layer = NULL,
  replicate_selector = NULL,
  nrep = NULL,
  A.msk = NULL,
  .envir = parent.frame(),
  envir_extra = NULL
)
}
\arguments{
\item{\dots}{Parameters passed on to other methods}

\item{object}{A character label for the component}

\item{main}{\code{main} takes an R expression that evaluates to where the latent variables
should be evaluated (coordinates, indices, continuous scalar (for rw2 etc)).
Arguments starting with weights, group, replicate behave similarly to main,
but for the corresponding features of \code{INLA::f()}.}

\item{weights, weights_layer, weights_selector}{Optional specification of effect scaling weights.
Same syntax as for \code{main}.}

\item{model}{Either one of "offset", "factor_full", "factor_contrast", "linear",
"fixed", or a model name or
object accepted by INLA's \code{f} function. If set to NULL, then "linear" is used
for vector inputs, and "fixed" for matrix input (converted internally to
an iid model with fixed precision)}

\item{mapper}{Information about how to do the mapping from the values evaluated in \code{main},
and to the latent variables. Auto-detects spde model objects in model and
extracts the mesh object to use as the mapper, and auto-generates mappers
for indexed models. (Default: NULL, for auto-determination)}

\item{main_layer, main_selector}{The \verb{_layer} is a numeric index or character name of which
layer/variable to extract from a covariate data object given in \code{main}
(Default: The effect component name, if it exists i the covariate object,
otherwise the first column of the covariate data frame)

The \verb{_selector} is character name of a variable whose contents determines which layer to
extract from a covariate for each data point. Overrides the \code{layer}.
(Default: NULL)}

\item{n}{The number of latent variables in the model. Should be auto-detected
for most or all models (Default: NULL, for auto-detection).
An error is given if it can't figure it out by itself.}

\item{values}{Specifies for what covariate/index values INLA should build
the latent model. Normally generated internally based on the mapping details.
(Default: NULL, for auto-determination)}

\item{season.length}{Passed on to \code{INLA::f()} for model \code{"seasonal"}
(TODO: check if this parameter is still fully handled)}

\item{copy}{character; label of other component that this component should
be a copy of. If the \code{fixed = FALSE}, a scaling constant is estimated, via a
hyperparameter. If \code{fixed = TRUE}, the component scaling is fixed, by
default to 1; for fixed scaling, it's more efficient to express the scaling
in the predictor expression instead of making a copy component.}

\item{group, group_mapper, group_layer, group_selector, ngroup}{Optional specification of kronecker/group model indexing.}

\item{control.group}{\code{list} of kronecker/group model parameters, currently
passed directly on to \code{INLA::f}}

\item{replicate, replicate_mapper, replicate_layer, replicate_selector, nrep}{Optional specification of indices for an independent
replication model. Same syntax as for \code{main}}

\item{A.msk}{TODO: check/fix/deprecate this parameter.
Likely doesn't work at the moment, and I've found no examples that use it.}

\item{.envir}{Evaluation environment}

\item{envir_extra}{TODO: check/fix this parameter.}
}
\description{
Similar to \code{glm()}, \code{gam()} and \code{inla()}, \code{\link[=bru]{bru()}} models can be constructed via
a formula-like syntax, where each latent effect is specified. However, in
addition to the parts of the syntax compatible with \code{INLA::inla}, \code{bru}
components offer additional functionality which facilitates modelling, and
the predictor expression can be specified separately, allowing more complex
and non-linear predictors to be defined. The formula syntax is just a way to
allow all model components to be defined in a single line of code, but the
definitions can optionally be split up into separate component definitions.
See Details for more information.

The \code{component} methods all rely on the \code{\link[=component.character]{component.character()}} method, that
defines a model component with a given label/name. The user usually
doesn't need to call these methods directly, but can instead supply a
formula expression that can be interpreted by the \code{\link[=component_list.formula]{component_list.formula()}}
method, called inside \code{\link[=bru]{bru()}}.
}
\details{
As shorthand, \code{\link[=bru]{bru()}} will understand basic additive formulae describing fixed effect
models. For instance, the
components specification \code{y ~ x} will define the linear combination of an
effect named \code{x} and an intercept to
the response \code{y} with respect to the likelihood family stated when calling \code{\link[=bru]{bru()}}. Mathematically,
the linear predictor \eqn{\eta} would be written down as

\deqn{\eta = \beta * x + c,}

where:

\itemize{
\item{\eqn{c} }{is the \emph{intercept}}
\item{\eqn{x }}{is a \emph{covariate}}
\item{\eqn{\beta} }{is a \emph{random variable} associated with \eqn{x} and}
\item{\eqn{\psi = \beta * x }}{ is called the \emph{random effect} of \eqn{x}}
}

A problem that arises when using this kind of R formula is that it does not
clearly reflect the mathematical
formula. For instance, when providing the formula to inla, the resulting
object will refer to the random
effect \eqn{\psi = \beta * x } as \code{x}. Hence, it is not clear if \code{x} refers to the covariate
or the effect of the covariate.

The \code{component.character} method is inlabru's equivalent to INLA's
\code{f} function but adds functionality that is unique to inlabru.

Deprecated parameters:
\itemize{
\item map: Use \code{main} instead.
\item mesh: Use \code{mapper} instead.
}
}
\section{Naming random effects}{


In INLA, the \code{f()} notation is used to define more complex models, but
a simple linear effect model can also be expressed as

\itemize{\item{\code{formula = y ~ f(x, model = "linear")},}}

where \code{f()} is the inla specific function to set up random effects of all kinds. The underlying
predictor would again be \eqn{\eta = \beta * x + c} but the result of fitting the model would state
\code{x} as the random effect's name. bru allows rewriting this formula in order to explicitly state
the name of the random effect and the name of the associated covariate. This is achieved by replacing \code{f}
with an arbitrary name that we wish to assign to the effect, e.g.

\itemize{\item{\code{components = y ~ psi(x, model = "linear")}.}}

Being able to discriminate between \eqn{x} and \eqn{\psi} is relevant because of two functionalities
bru offers. The formula parameters of both \code{\link[=bru]{bru()}} and the prediction method \link{predict.bru}
are interpreted in the mathematical sense. For instance, \code{predict} may be used to analyze the
analytical combination of the covariate \eqn{x} and the intercept using

\itemize{\item{\verb{predict(fit, data.frame(x=2)), ~ exp(psi + Intercept)}.}}

which corresponds to the mathematical expression \ifelse{html}{\out{e <sup>&#946; + c</sup>}}{\eqn{e^{x \beta + c}}}.

On the other hand, predict may be used to only look at a transformation of
the latent variable \eqn{\beta_\psi}

\itemize{\item{\code{predict(fit, NULL, ~ exp(psi_latent))}.}}

which corresponds to the mathematical expression \ifelse{html}{\out{e <sup>&#946;</sup>}}{\eqn{e^{\beta}}}.
}

\examples{
# As an example, let us create a linear component. Here, the component is
# called "myLinearEffectOfX" while the covariate the component acts on is
# called "x". Note that a list of components is returned because the
# formula may define multiple components

cmp <- component_list(~ myLinearEffectOfX(main = x, model = "linear"))
summary(cmp)
# Equivalent shortcuts:
cmp <- component_list(~ myLinearEffectOfX(x, model = "linear"))
cmp <- component_list(~ myLinearEffectOfX(x))
# Individual component
cmp <- component("myLinearEffectOfX", main = x, model = "linear")
summary(cmp)
\donttest{
if (require("INLA", quietly = TRUE)) {

  # As an example, let us create a linear component. Here, the component is
  # called "myEffectOfX" while the covariate the component acts on is called "x":

  cmp <- component("myEffectOfX", main = x, model = "linear")
  summary(cmp)

  # A more complicated component:
  cmp <- component("myEffectOfX",
    main = x,
    model = inla.spde2.matern(inla.mesh.1d(1:10))
  )

  # Compound fixed effect component, where x and z are in the input data.
  # The formula will be passed on to MatrixModels::model.Matrix:
  cmp <- component("eff", ~ -1 + x:z, model = "fixed")
  summary(cmp)
}
}

}
\seealso{
Other component constructors: 
\code{\link{component_list}()}
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and
Finn Lindgren \email{Finn.Lindgren@gmail.com}
}
\concept{component constructors}
