% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNCBI.R
\name{getNCBI}
\alias{getNCBI}
\title{Get NCBI taxonomy data}
\usage{
getNCBI(species, host = TRUE)
}
\arguments{
\item{species}{a vector of species names}

\item{host}{(boolean) affects column naming (nice to keep host and pathogen separate)}
}
\value{
a data.frame with nrow == length(species)
}
\description{
Process through a vector of species names to obtain taxonomic data
}
\examples{
  mouse <- getNCBI("Peromyscus leucopus")
  worm  <- getNCBI("Ascaris lumbricoides", host=FALSE)
}
