## ----setup,echo=FALSE, include=FALSE------------------------------------------
# setup chunk
NOT_CRAN <- identical(tolower(Sys.getenv("NOT_CRAN")),"true")
knitr::opts_chunk$set(purl = NOT_CRAN)
library(insee)
library(tidyverse)

embed_png <- function(path, dpi = NULL) {
  meta <- attr(png::readPNG(path, native = TRUE, info = TRUE), "info")
  if (!is.null(dpi)) meta$dpi <- rep(dpi, 2)
  knitr::asis_output(paste0(
    "<img src='", path, "'",
    " width=", round(meta$dim[1] / (meta$dpi[1] / 96)),
    " height=", round(meta$dim[2] / (meta$dpi[2] / 96)),
    " />"
  ))}

## ---- echo = FALSE------------------------------------------------------------
embed_png("inflation.png")

## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(kableExtra)
library(magrittr)
library(htmltools)
library(prettydoc)

## ----message = FALSE, warning=FALSE, eval = FALSE-----------------------------
#  # please download the Github version
#  # devtools::install_github("hadrilec/insee")
#  library(tidyverse)
#  library(lubridate)
#  library(insee)
#  
#  idbank_list = get_idbank_list()
#  
#  df_idbank_list_selected =
#    idbank_list %>%
#    filter(nomflow == "IPC-2015") %>% #Inflation dataset
#    filter(dim1 == "M") %>% # monthly
#    filter(str_detect(dim4, "^[0-9]{2}$")) %>% # coicop aggregation level
#    filter(dim6 == "INDICE") %>% # index
#    filter(dim7 == "ENSEMBLE") %>% # all kinds of household
#    filter(dim8 == "FE") %>% # all France including overseas departements
#    mutate(title = get_insee_title(idbank))
#  
#  list_idbank = df_idbank_list_selected %>% pull(idbank)
#  
#  data =
#    get_insee_idbank(list_idbank, startPeriod = "2015-01") %>%
#    split_title()
#  
#  data_plot = data %>%
#    mutate(TITLE_EN6 = case_when(is.na(TITLE_EN6) ~ TITLE_EN5,
#                              TRUE ~ as.character(TITLE_EN6))) %>%
#    mutate(TITLE_EN6 = substr(TITLE_EN6, 1 , 22)) %>%
#    mutate(month = month(DATE)) %>%
#    arrange(DATE) %>%
#    group_by(TITLE_EN6, month) %>%
#    mutate(growth = 100 * (OBS_VALUE / dplyr::lag(OBS_VALUE) - 1))
#  
#  ggplot(data_plot, aes(x = DATE, y = growth)) +
#    geom_col() +
#    facet_wrap(~TITLE_EN6, scales = "free") +
#    ggtitle("French inflation, by product category, year-on-year") +
#    labs(subtitle = sprintf("Last updated : %s", data_plot$TIME_PERIOD[nrow(data_plot)]))
#  

