% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_idbank_list.R
\name{get_idbank_list}
\alias{get_idbank_list}
\title{Download a full INSEE's series key list}
\usage{
get_idbank_list(dataset = NULL)
}
\arguments{
\item{dataset}{if a dataset name is provided, only a subset of the data is delivered, otherwise
all the data is returned}
}
\value{
a tibble the idbank dataset
}
\description{
Download a full INSEE's series key list
}
\details{
Download a mapping dataset betwen INSEE series keys (idbank) and SDMX series names.
Under the hood the get_idbank_list uses download.file function from utils, the user can change the mode argument with the following
command : Sys.getenv(INSEE_download_option_idbank_list = "wb")
If makes an update, the user can also change the zip file downloaded, the data file contained in the zip and data the separator  :
Sys.setenv(INSEE_idbank_dataset_path = "new_zip_file_link");Sys.setenv(INSEE_idbank_sep = ",");Sys.setenv(INSEE_idbank_dataset_file = "new_data_file_name")
}
\examples{
\donttest{idbank_list = get_idbank_list()}
}
