% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{trim_ws}
\alias{trim_ws}
\alias{trim_ws.data.frame}
\alias{n_unique}
\alias{n_unique.default}
\alias{safe_deparse}
\title{Small helper functions}
\usage{
trim_ws(x, ...)

\method{trim_ws}{data.frame}(x, character_only = TRUE, ...)

n_unique(x, ...)

\method{n_unique}{default}(x, na.rm = TRUE, ...)

safe_deparse(x, ...)
}
\arguments{
\item{x}{A (character) vector, or for some functions may also be a data frame.}

\item{...}{Currently not used.}

\item{character_only}{Logical, if \code{TRUE} and \code{x} is a data frame or list,
only processes character vectors.}

\item{na.rm}{Logical, if missing values should be removed from the input.}
}
\value{
For a vector, \code{n_unique} always returns an integer value, even if the
input is \code{NULL} (the return value will be \code{0} then). For data frames or lists,
\code{n_unique()} returns a named numeric vector, with the number of unique values
for each element.
}
\description{
Collection of small helper functions. \code{trim_ws()} is an
efficient function to trim leading and trailing whitespaces from character
vectors or strings. \code{n_unique()} returns the number of unique values in a
vector. \code{safe_deparse()} is comparable to \code{deparse1()}, i.e. it can safely
deparse very long expressions into a single string.
}
\examples{
trim_ws("  no space!  ")
n_unique(iris$Species)
}
