% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_names.R
\name{clean_names}
\alias{clean_names}
\title{Get clean names of model terms}
\usage{
clean_names(x)
}
\arguments{
\item{x}{A fitted model, or a character vector.}
}
\value{
The "cleaned" variable names as character vector, i.e. pattern
  like \code{s()} for splines or \code{log()} are removed from
  the model terms.
}
\description{
This function "cleans" names of model terms (or a character
  vector with such names) by removing patterns like \code{log()} or
  \code{as.factor()} etc.
}
\note{
Typically, this method is intended to work on character vectors,
  in order to remove patterns that obscure the variable names. For
  convenience reasons it is also possible to call \code{clean_names()}
  also on a model object. If \code{x} is a regression model, this
  function is (almost) equal to calling \code{find_variables()}. The
  main difference is that \code{clean_names()} always returns a character
  vector, while \code{find_variables()} returns a list of character
  vectors, unless \code{flatten = TRUE}. See 'Examples'.
}
\examples{
# example from ?stats::glm
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- as.numeric(gl(3, 1, 9))
treatment <- gl(3, 3)
m <- glm(counts ~ log(outcome) + as.factor(treatment), family = poisson())
clean_names(m)

# difference "clean_names()" and "find_variables()"
library(lme4)
m <- glmer(
  cbind(incidence, size - incidence) ~ period + (1 | herd),
  data = cbpp,
  family = binomial
)

clean_names(m)
find_variables(m)
find_variables(m, flatten = TRUE)
}
