% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_cor.R
\name{inspect_cor}
\alias{inspect_cor}
\title{Summarise and compare Pearson's correlation coefficients for numeric columns in one or two dataframes.}
\usage{
inspect_cor(df1, df2 = NULL, method = "pearson", with_col = NULL,
  alpha = 0.05, show_plot = FALSE)
}
\arguments{
\item{df1}{A data frame.}

\item{df2}{An optional second data frame for comparing correlation 
coefficients.  Defaults to \code{NULL}.}

\item{method}{a character string indicating which type of correlation coefficient to use, one 
of "pearson", "kendall", or "spearman", which can be abbreviated.}

\item{with_col}{Character vector of column names to calculate correlations with.  When set to 
the default, \code{NULL}, all pairs of correlations are returned.}

\item{alpha}{Alpha level for correlation confidence intervals.  Defaults to 0.05.}

\item{show_plot}{(Deprecated) Logical flag indicating whether a plot should be shown.
Superseded by the function \code{show_plot()} and will be dropped in a future version.}
}
\value{
A tibble summarising and comparing the correlations for each numeric column 
in one or a pair of data frames.
}
\description{
Summarise and compare Pearson's correlation coefficients for numeric columns in one or two dataframes.
}
\details{
When only \code{df1} is specified, a tibble is returned which 
contains correlation coefficients 
\itemize{
  \item \code{col_1}, \code{co1_2} character vectors containing names of numeric columns in \code{df1}.
  \item \code{corr} numeric values of Pearson's correlation coefficient.
  \item \code{lower}, \code{upper} lower and upper values of the confidence interval for the correlations.
  \item \code{p_value} p-value associated with the null hypothesis of 0 correlation, small values 
  indicate evidence that the true correlation is not equal to 0.
}
If `df1` has class `grouped_df`, then correlations will be calculated within the grouping levels 
and the tibble returned will have an additional column corresponding to the group labels.

When both \code{df1} and \code{df2} are specified, the tibble returned performs a comparison of the 
correlation coefficients across the dataframes.
\itemize{
  \item \code{col_1}, \code{co1_2} character vectors containing names of numeric columns in either 
  \code{df1} or \code{df2}.
  \item \code{corr_1}, \code{corr_2} numeric values of Pearson's correlation coefficient observed in 
  \code{df1} and \code{df2}, respectively.
  \item \code{p_value} p-value associated with the null hypothesis that the two correlation coefficients 
  are the same.  Small values indicate that the true correlation coefficients differ between the two 
  dataframes.
}
}
\examples{
data("starwars", package = "dplyr")
# correlations in numeric columns
inspect_cor(starwars)
# only show correlations with 'mass' column
inspect_cor(starwars, with_col = "mass")
# compare correlations with a different data frame
inspect_cor(starwars, starwars[1:10, ])

# NOT RUN - change in correlation over time
# library(dplyr)
# tech_grp <- tech \%>\% 
#         group_by(year) \%>\%
#         inspect_cor()
# tech_grp \%>\% show_plot()     

}
