% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/updateR.R
\name{get.installed.R.folders}
\alias{get.installed.R.folders}
\title{Returns folder names with R installations}
\usage{
get.installed.R.folders(sort_by_version = TRUE, add_version_to_name = TRUE)
}
\arguments{
\item{sort_by_version}{should the returned vector be sorted by the version number? (default is yes - so that the first element is of the newest version of R) should the user be given the option to choose between which two libraries to copy the packages?  If FALSE (default), the folders are copied from the before-newest R installation to the newest R installation.}

\item{add_version_to_name}{should the version number be added to the vector of folders? (default is yes)}
}
\value{
Returns a character vector (possibly named, possibly sorted) of the folders where there are R installations.
}
\description{
The function finds the folders where there are R installations.  This is important for deciding what to uninstall, and where from and to to move libraries.
This function ignores installations of R-devel at this point.
Also, this function is based on only looking at the folders above the current installation of R.  If there are other isntallations of R outside the above folder, they will not be listed.
}
\examples{
\dontrun{
get.installed.R.folders()
# returns the sorted and named vector of
# folder names where R is installed (in different versions).
#  The first element is
# the folder of the newest version of R.

get.installed.R.folders(F, F)
# returns the folder names where R is
# installed (in different versions) - no sorting of
# the folder names was performed
}
}
\seealso{
\link{copy.packages.between.libraries}
}

