% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivglm.R
\name{iv.glm}
\alias{iv.glm}
\title{Estimate generalized linear models with an instrumental variable.}
\usage{
iv.glm(model_formula, instrument_formula = NULL, data = NULL,
  family = binomial, link = "logit", ...)
}
\arguments{
\item{model_formula}{The formula of the main regression problem.}

\item{instrument_formula}{The formula for the first stage of the regression problem.  Estimate an endogenous variable from one (or more) instruments. If blank, defaults to regular glm.}

\item{data}{(optional) A data frame containing all variables for the regression model.}

\item{family}{The distribution family of the outcome variable.}

\item{link}{The link function to the outcome variable.}

\item{...}{Additional arguments to pass to glm().}
}
\description{
This function allows you to estimate two stage generalized linear models in one step.
}
\examples{
# Fake data
N <- 1000
z <- rnorm(N, 1, 1)
error <- rnorm(N, 1, 1)
x <- z + error + rnorm(N, 1, 1)
y <- rbinom(N, 1, invlogit(x + error))

# Fit glm
fit_glm <- glm( y ~ x, family = binomial(link = 'logit'))

# Fit with iv
fit_iv <- iv.glm(y ~ x, x ~ z, family = binomial, link = 'logit')

summary(fit_glm)
summary(fit_iv)
}
\keyword{instrument}
