% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_factors.R
\name{rating_factors}
\alias{rating_factors}
\title{Include reference group in regression output}
\usage{
rating_factors(
  ...,
  model_data = NULL,
  exposure = NULL,
  exponentiate = TRUE,
  signif_stars = TRUE,
  round_exposure = 0
)
}
\arguments{
\item{...}{glm object(s) produced by \code{glm()}}

\item{model_data}{data.frame used to create glm object(s), this should only
be specified in case the exposure is desired in the output, default value is NULL}

\item{exposure}{column in \code{model_data} with exposure, default value is NULL}

\item{exponentiate}{logical indicating whether or not to exponentiate the
coefficient estimates. Defaults to TRUE.}

\item{signif_stars}{show significance stars for p-values (defaults to TRUE)}

\item{round_exposure}{number of digits for exposure (defaults to 0)}
}
\value{
data.frame
}
\description{
Extract coefficients in terms of the original levels of the
coefficients rather than the coded variables.
}
\details{
A fitted linear model has coefficients for the contrasts of the
factor terms, usually one less in number than the number of levels. This
function re-expresses the coefficients in the original coding. This
function is adopted from dummy.coef(). Our adoption prints a data.frame as output.
}
\examples{
library(dplyr)
df <- MTPL2 \%>\%
  mutate(across(c(area), as.factor)) \%>\%
  mutate(across(c(area), ~biggest_reference(., exposure)))

mod1 <- glm(nclaims ~ area + premium, offset = log(exposure), family = poisson(), data = df)
mod2 <- glm(nclaims ~ area, offset = log(exposure), family = poisson(), data = df)

rating_factors(mod1, mod2, model_data = df, exposure = exposure)

}
\author{
Martin Haringa
}
