% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance_overdispersion.R
\name{check_overdispersion}
\alias{check_overdispersion}
\title{Check overdispersion of Poisson GLM}
\usage{
check_overdispersion(object)
}
\arguments{
\item{object}{fitted model of class \code{glm} and family Poisson}
}
\value{
A list with dispersion ratio, chi-squared statistic, and p-value.
}
\description{
Check Poisson GLM for overdispersion.
}
\details{
A dispersion ratio larger than one indicates overdispersion, this
occurs when the observed variance is higher than the variance of the
theoretical model. If the dispersion ratio is close to one, a Poisson model
fits well to the data. A p-value < .05 indicates overdispersion.
Overdispersion > 2 probably means there is a larger problem with the data:
check (again) for outliers, obvious lack of fit. Adopted from
\code{performance::check_overdispersion()}.
}
\examples{
x <- glm(nclaims ~ area, offset = log(exposure), family = poisson(),
  data = MTPL2)
check_overdispersion(x)

}
\references{
\itemize{
\item Bolker B et al. (2017): \href{http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html}{GLMM FAQ.}
}
}
\author{
Martin Haringa
}
