% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\title{Performance of fitted GLMs}
\usage{
model_performance(...)
}
\arguments{
\item{...}{One or more objects of class \code{glm}.}
}
\value{
data frame
}
\description{
Compute indices of model performance for (one or more) GLMs.
}
\details{
The following indices are computed:
\describe{
\item{AIC}{Akaike's Information Criterion}
\item{BIC}{Bayesian Information Criterion}
\item{RMSE}{Root mean squared error}
}

Adopted from \code{performance::model_performance()}.
}
\examples{
m1 <- glm(nclaims ~ area, offset = log(exposure), family = poisson(),
          data = MTPL2)
m2 <- glm(nclaims ~ area, offset = log(exposure), family = poisson(),
          data = MTPL2)
model_performance(m1, m2)

}
\author{
Martin Haringa
}
