% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-simplextree.r
\name{as_rcpp_simplextree}
\alias{as_rcpp_simplextree}
\alias{as_rcpp_simplextree.default}
\alias{as_rcpp_simplextree.Rcpp_SimplexTree}
\alias{as_rcpp_simplextree.gudhi.simplex_tree.SimplexTree}
\alias{as_rcpp_simplextree.igraph}
\alias{as_rcpp_simplextree.network}
\title{Coerce objects to class 'Rcpp_SimplexTree'}
\usage{
as_rcpp_simplextree(x, ...)

\method{as_rcpp_simplextree}{default}(x, ...)

\method{as_rcpp_simplextree}{Rcpp_SimplexTree}(x, ...)

\method{as_rcpp_simplextree}{gudhi.simplex_tree.SimplexTree}(x, ...)

\method{as_rcpp_simplextree}{igraph}(x, index = NULL, ...)

\method{as_rcpp_simplextree}{network}(x, index = NULL, ...)
}
\arguments{
\item{x}{An R object to be coerced. See Details.}

\item{...}{Additional arguments passed to methods.}

\item{index}{Integer-valued vertex attribute to be used as 0-simplex indices.
Ignored if \code{NULL} (the default).}
}
\value{
An instance of a simplex tree, exposed as an Rcpp Module with class
'Rcpp_SimplexTree'.
}
\description{
Coerce objects to 'Rcpp_SimplexTree' objects, as implemented in
\link[simplextree:simplextree-package]{the simplextree package}.
}
\details{
\code{as_rcpp_simplextree()} is a generic function with specific methods for
different simplicial complex S3 classes. It returns an object of class
\link[simplextree:simplex_tree]{'Rcpp_SimplexTree'}, which is an \link[Rcpp:Module]{Rcpp Module} that exposes an instance of a C++ instance of a simplex
tree.
}
\examples{
# convert a TDA filtration object
t <- 2 * pi * c(0, 1, 3, 6) / 7
rf <- TDA::ripsFiltration(
  cbind(x = cos(t), y = sin(t)),
  maxdimension = 2L, maxscale = 1.7
)
print(rf$cmplx)
st_rf <- as_rcpp_simplextree(rf)
print(st_rf)
st_rf2 <- as_rcpp_simplextree(rf$cmplx)
print(st_rf2)

\dontrun{

# convert a Python GUDHI simplex tree
gd <- reticulate::import("gudhi")
gd_st <- gd$SimplexTree()
for (s in list(3:5, 5:6, 8)) gd_st$insert(as.list(s))
st_gd <- as_rcpp_simplextree(gd_st)
st_gd$as_list()
}

# convert an igraph object
ig <- igraph::graph(c(1,2, 2,3, 1,3, 3,4))
print(ig)
st_ig <- as_rcpp_simplextree(ig)
print(st_ig)

# specify 0-simplex indices
set.seed(0L)
ig <- igraph::set_vertex_attr(ig, "id", value = sample(igraph::vcount(ig)) + 1L)
igraph::V(ig)$id
igraph::as_edgelist(ig)
st_ig <- as_rcpp_simplextree(ig, index = "id")
st_ig$vertices
st_ig$edges

# convert a network object
el <- data.frame(tails = c(1, 2, 1, 3), heads = c(2, 3, 3, 4))
nw <- network::network.edgelist(el, network::network.initialize(4))
print(nw)
st_nw <- as_rcpp_simplextree(nw)
print(st_nw)
}
